/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.functions.CopyApplier;

class LazotepConvertCopyEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
            blueprint.removePTCDA();
            blueprint.getPower().setModifiedBaseValue(4);
            blueprint.getToughness().setModifiedBaseValue(4);
            blueprint.addSubType(new SubType[]{SubType.ZOMBIE});
            blueprint.getColor().addColor(ObjectColor.BLACK);
            return true;
        }
    };
    private static final FilterCard filter = new FilterCreatureCard("creature card in a graveyard");

    public LazotepConvertCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "as a copy of any creature card in a graveyard, except it's a 4/4 black Zombie in addition to its other types";
    }

    private LazotepConvertCopyEffect(LazotepConvertCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card copyFromCard = game.getCard(target.getFirstTarget());
        if (copyFromCard == null) {
            return true;
        }
        Card modifiedCopy = copyFromCard.copy();
        applier.apply(game, (MageObject)modifiedCopy, source, source.getSourceId());
        game.addEffect((ContinuousEffect)new CopyEffect(Duration.Custom, (MageObject)modifiedCopy, source.getSourceId()).setApplier(applier), source);
        return true;
    }

    public LazotepConvertCopyEffect copy() {
        return new LazotepConvertCopyEffect(this);
    }
}

