/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.players.Player;

class LeadershipVacuumEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    LeadershipVacuumEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player returns each commander they control from the battlefield to the command zone";
    }

    private LeadershipVacuumEffect(LeadershipVacuumEffect effect) {
        super((OneShotEffect)effect);
    }

    public LeadershipVacuumEffect copy() {
        return new LeadershipVacuumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        return player.moveCards(new HashSet(game.getBattlefield().getAllActivePermanents(filter, player.getId(), game)), Zone.COMMAND, source, game);
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

