/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LeaveNoTraceEffect
extends OneShotEffect {
    static final FilterPermanent filter = new FilterPermanent("enchantment");

    LeaveNoTraceEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target enchantment and each other enchantment that shares a color with it";
    }

    private LeaveNoTraceEffect(LeaveNoTraceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            ObjectColor color = target.getColor(game);
            target.destroy(source, game, false);
            for (Permanent p : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
                if (!p.getColor(game).shares(color)) continue;
                p.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public LeaveNoTraceEffect copy() {
        return new LeaveNoTraceEffect(this);
    }

    static {
        filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
    }
}

