/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.common.delayed.AtTheBeginOfCombatDelayedTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.l.LegionsInitiativeExileEffect;
import mage.cards.l.LegionsInitiativeReturnFromExileEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;

public final class LegionsInitiative
extends CardImpl {
    private static final FilterCreaturePermanent filterRedCreature = new FilterCreaturePermanent("Red creatures");
    private static final FilterCreaturePermanent filterWhiteCreature = new FilterCreaturePermanent("White creatures");

    public LegionsInitiative(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{R}{W}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostControlledEffect(1, 0, Duration.WhileOnBattlefield, (FilterPermanent)filterRedCreature)));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostControlledEffect(0, 1, Duration.WhileOnBattlefield, (FilterPermanent)filterWhiteCreature)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new LegionsInitiativeExileEffect(), (Cost)new ManaCostsImpl("{R}{W}"));
        ability.addEffect((Effect)new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new AtTheBeginOfCombatDelayedTriggeredAbility((Effect)new LegionsInitiativeReturnFromExileEffect())));
        ability.addCost((Cost)new ExileSourceCost());
        this.addAbility((Ability)ability);
    }

    private LegionsInitiative(LegionsInitiative card) {
        super((CardImpl)card);
    }

    public LegionsInitiative copy() {
        return new LegionsInitiative(this);
    }

    static {
        filterRedCreature.add((Predicate)new ColorPredicate(ObjectColor.RED));
        filterWhiteCreature.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

