/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LegionsInitiativeExileEffect
extends OneShotEffect {
    LegionsInitiativeExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creatures you control.";
    }

    private LegionsInitiativeExileEffect(LegionsInitiativeExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        UUID exileZone = CardUtil.getExileZoneId((Game)game, (Ability)source);
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return controller.moveCardsToExile(cards.getCards(game), source, game, true, exileZone, CardUtil.getSourceName((Game)game, (Ability)source));
    }

    public LegionsInitiativeExileEffect copy() {
        return new LegionsInitiativeExileEffect(this);
    }
}

