/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LegionsToAshesEffect
extends OneShotEffect {
    LegionsToAshesEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target nonland permanent an opponent controls and all tokens that player controls with the same name as that permanent.";
    }

    private LegionsToAshesEffect(LegionsToAshesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LegionsToAshesEffect copy() {
        return new LegionsToAshesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || targetPermanent == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent();
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((Predicate)new ControllerIdPredicate(targetPermanent.getControllerId()));
        filter.add((Predicate)new NamePredicate(targetPermanent.getName()));
        HashSet<Permanent> toExile = new HashSet<Permanent>(game.getBattlefield().getActivePermanents(filter, controller.getId(), source, game));
        toExile.add(targetPermanent);
        controller.moveCards(toExile, Zone.EXILED, source, game);
        return true;
    }
}

