/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LeoninArbiterIgnoreEffect
extends OneShotEffect {
    private final String keyString;

    public LeoninArbiterIgnoreEffect(String keyString) {
        super(Outcome.Benefit);
        this.keyString = keyString;
        this.staticText = "Any player may pay {2} for that player to ignore this effect until end of turn";
    }

    private LeoninArbiterIgnoreEffect(LeoninArbiterIgnoreEffect effect) {
        super((OneShotEffect)effect);
        this.keyString = effect.keyString;
    }

    public LeoninArbiterIgnoreEffect copy() {
        return new LeoninArbiterIgnoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        String key = permanent.getId() + this.keyString;
        long zoneChangeCount = permanent.getZoneChangeCounter(game);
        long turnNum = game.getTurnNum();
        Long activationState = zoneChangeCount << 32 | turnNum & 0xFFFFFFFFL;
        AbstractMap.SimpleImmutableEntry turnIgnoringPlayersPair = (AbstractMap.SimpleImmutableEntry)game.getState().getValue(key);
        if (turnIgnoringPlayersPair == null || !activationState.equals(turnIgnoringPlayersPair.getKey())) {
            turnIgnoringPlayersPair = new AbstractMap.SimpleImmutableEntry(activationState, new HashSet());
            game.getState().setValue(key, turnIgnoringPlayersPair);
        }
        ((Set)turnIgnoringPlayersPair.getValue()).add(game.getPriorityPlayerId());
        return true;
    }
}

