/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LeylineOfCombustionTriggeredAbility
extends TriggeredAbilityImpl {
    LeylineOfCombustionTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private LeylineOfCombustionTriggeredAbility(LeylineOfCombustionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LeylineOfCombustionTriggeredAbility copy() {
        return new LeylineOfCombustionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        StackObject sourceObject = game.getStack().getStackObject(event.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        Player targetter = game.getPlayer(event.getPlayerId());
        if (targetter == null || !targetter.hasOpponent(this.controllerId, game)) {
            return false;
        }
        if (!(event.getTargetId().equals(this.controllerId) || (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && permanent.isControlledBy(this.controllerId))) {
            return false;
        }
        HashSet<UUID> sourceObjects = (HashSet<UUID>)game.getState().getValue("sourceObjects" + this.getId());
        if (sourceObjects == null) {
            sourceObjects = new HashSet<UUID>();
        }
        if (!sourceObjects.add(sourceObject.getId())) {
            return false;
        }
        game.getState().setValue("sourceObjects" + this.getId(), sourceObjects);
        this.getEffects().clear();
        DamageTargetEffect effect = new DamageTargetEffect(2);
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId(), game));
        this.addEffect((Effect)effect);
        return true;
    }

    public String getRule() {
        return "Whenever you and/or at least one permanent you control becomes the target of a spell or ability an opponent controls, {this} deals 2 damage to that player.";
    }
}

