/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LiarsPendulumEffect
extends OneShotEffect {
    LiarsPendulumEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Choose a card name. Target opponent guesses whether a card with that name is in your hand. You may reveal your hand. If you do and your opponent guessed wrong, draw a card";
    }

    private LiarsPendulumEffect(LiarsPendulumEffect effect) {
        super((OneShotEffect)effect);
    }

    public LiarsPendulumEffect copy() {
        return new LiarsPendulumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(controller, game, source, false);
        boolean opponentGuess = false;
        if (opponent.chooseUse(Outcome.Neutral, "Is the chosen card (" + cardName + ") in " + controller.getLogName() + "'s hand?", source, game)) {
            opponentGuess = true;
        }
        boolean rightGuess = !opponentGuess;
        for (Card card : controller.getHand().getCards(game)) {
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            rightGuess = opponentGuess;
        }
        game.informPlayers(opponent.getLogName() + " guesses that " + cardName + " is " + (opponentGuess ? "" : "not") + " in " + controller.getLogName() + "'s hand");
        if (controller.chooseUse(this.outcome, "Reveal your hand?", source, game)) {
            controller.revealCards("hand of " + controller.getName(), controller.getHand(), game);
            if (!rightGuess) {
                controller.drawCards(1, source, game);
            }
        }
        return true;
    }
}

