/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class LibraryOfLengEffect
extends ReplacementEffectImpl {
    private UUID cardId;
    private int zoneChangeCounter;

    public LibraryOfLengEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If an effect causes you to discard a card, discard it, but you may put it on top of your library instead of into your graveyard";
    }

    private LibraryOfLengEffect(LibraryOfLengEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.cardId = effect.cardId;
        this.zoneChangeCounter = effect.zoneChangeCounter;
    }

    public LibraryOfLengEffect copy() {
        return new LibraryOfLengEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARD_CARD || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARD_CARD && event.getFlag()) {
            return event.getPlayerId().equals(source.getControllerId());
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.cardId) && game.getState().getZoneChangeCounter(event.getTargetId()) == this.zoneChangeCounter) {
            return ((ZoneChangeEvent)event).getFromZone() == Zone.HAND && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD;
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARD_CARD) {
            Card card = game.getCard(event.getTargetId());
            if (card != null) {
                this.cardId = card.getId();
                this.zoneChangeCounter = game.getState().getZoneChangeCounter(this.cardId);
            }
            return false;
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            Player controller = game.getPlayer(source.getControllerId());
            Card card = game.getCard(event.getTargetId());
            if (controller != null && card != null) {
                this.cardId = null;
                this.zoneChangeCounter = 0;
                if (controller.chooseUse(this.outcome, "Put " + card.getIdName() + " on top of your library instead?", source, game)) {
                    CardsImpl cardsToLibrary = new CardsImpl(card);
                    controller.putCardsOnTopOfLibrary((Cards)cardsToLibrary, game, source, false);
                    return true;
                }
            }
        }
        return false;
    }
}

