/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class LichDamageEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("nontoken permanent");

    LichDamageEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice that many nontoken permanents. If you can't, you lose the game";
    }

    private LichDamageEffect(LichDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public LichDamageEffect copy() {
        return new LichDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(SavedDamageValue.MANY.calculate(game, source, (Effect)this), (FilterPermanent)filter);
        if (target.canChoose(controller.getId(), source, game) && controller.choose(Outcome.Sacrifice, (Target)target, source, game)) {
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
            return true;
        }
        controller.lost(game);
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

