/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LidlessGazeEffect
extends OneShotEffect {
    LidlessGazeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of each player's library. Until the end of your next turn, you may play those cards, and mana of any type can be spent to cast them.";
    }

    private LidlessGazeEffect(LidlessGazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LidlessGazeEffect copy() {
        return new LidlessGazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        MageObject sourceObject = source.getSourceObject(game);
        String exileName = sourceObject == null ? null : sourceObject.getIdName();
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().removeFromTop(game)) == null) continue;
            controller.moveCardsToExile(card, source, game, true, exileId, exileName);
            cards.add(card);
        }
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)true, (UUID)controller.getId(), null);
        }
        return true;
    }
}

