/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LifebloodHydraEffect
extends OneShotEffect {
    LifebloodHydraEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain life and draw cards equal to its power";
    }

    private LifebloodHydraEffect(LifebloodHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public LifebloodHydraEffect copy() {
        return new LifebloodHydraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent diedPermanent = (Permanent)this.getValue("permanentLeftBattlefield");
            if (diedPermanent != null) {
                controller.gainLife(diedPermanent.getPower().getValue(), game, source);
                controller.drawCards(diedPermanent.getPower().getValue(), source, game);
            }
            return true;
        }
        return false;
    }
}

