/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LifelineEffect
extends OneShotEffect {
    LifelineEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return the first card to the battlefield under its owner's control at the beginning of the next end step";
    }

    private LifelineEffect(LifelineEffect effect) {
        super((OneShotEffect)effect);
    }

    public LifelineEffect copy() {
        return new LifelineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
            effect.setText("return that card to the battlefield under it's owner's control at the beginning of the next end step");
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect, TargetController.ANY), source);
            return true;
        }
        return false;
    }
}

