/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LightFromWithinEffect
extends ContinuousEffectImpl {
    LightFromWithinEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Each creature you control gets +1/+1 for each white mana symbol in its mana cost";
    }

    private LightFromWithinEffect(LightFromWithinEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public LightFromWithinEffect copy() {
        return new LightFromWithinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game)) {
            int chroma = creature.getManaCost().getMana().getWhite();
            if (chroma <= 0) continue;
            creature.addPower(chroma);
            creature.addToughness(chroma);
        }
        return true;
    }
}

