/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class LightPawsEmperorsVoiceEffect
extends OneShotEffect {
    LightPawsEmperorsVoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "if you cast it, you may search your library for an Aura card with mana value less than or equal to that Aura and with a different name than each Aura you control, put that card onto the battlefield attached to {this}, then shuffle";
    }

    private LightPawsEmperorsVoiceEffect(LightPawsEmperorsVoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public LightPawsEmperorsVoiceEffect copy() {
        return new LightPawsEmperorsVoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent aura = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (player == null || aura == null || !player.chooseUse(this.outcome, "Search for an Aura?", source, game)) {
            return false;
        }
        FilterCard filter = new FilterCard("Aura card with mana value less than or equal to " + aura.getManaValue());
        filter.add((Predicate)SubType.AURA.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, aura.getManaValue() + 1));
        filter.add((ObjectSourcePlayerPredicate)LightPawsEmperorsVoiceEffectPredicate.instance);
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (card != null && permanent != null && new AuraCardCanAttachToPermanentId(permanent.getId()).apply(card, game)) {
            game.getState().setValue("attachTo:" + card.getId(), (Object)permanent);
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            permanent.addAttachment(card.getId(), source, game);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    private static enum LightPawsEmperorsVoiceEffectPredicate implements ObjectSourcePlayerPredicate<Card>
    {
        instance;

        private static final FilterPermanent filter;

        public boolean apply(ObjectSourcePlayer<Card> input, Game game) {
            return game.getBattlefield().getActivePermanents(filter, input.getPlayerId(), input.getSource(), game).stream().filter(Objects::nonNull).noneMatch(permanent -> CardUtil.haveSameNames((MageObject)permanent, (MageObject)((MageObject)input.getObject())));
        }

        static {
            filter = new FilterControlledPermanent(SubType.AURA);
        }
    }
}

