/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElementalTokenWithHaste;
import mage.game.permanent.token.Token;
import mage.players.Player;

class LightningCoilsEffect
extends OneShotEffect {
    LightningCoilsEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} has five or more charge counters on it, remove all of them from it and create that many 3/1 red Elemental creature tokens with haste. Exile them at the beginning of the next end step.";
    }

    private LightningCoilsEffect(LightningCoilsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int counters;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && controller != null && (counters = permanent.getCounters(game).getCount(CounterType.CHARGE)) >= 5) {
            permanent.removeAllCounters(CounterType.CHARGE.getName(), source, game);
            CreateTokenEffect effect = new CreateTokenEffect((Token)new ElementalTokenWithHaste(), counters);
            effect.apply(game, source);
            effect.exileTokensCreatedAtNextEndStep(game, source);
            return true;
        }
        return false;
    }

    public LightningCoilsEffect copy() {
        return new LightningCoilsEffect(this);
    }
}

