/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.cards.l.LikenessLooterCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.functions.CopyApplier;

class LikenessLooterEffect
extends OneShotEffect {
    LikenessLooterEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of target creature card in your graveyard with mana value X, except it has flying and this ability.";
    }

    private LikenessLooterEffect(LikenessLooterEffect effect) {
        super((OneShotEffect)effect);
    }

    public LikenessLooterEffect copy() {
        return new LikenessLooterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        Card copyFromCard = game.getCard(source.getFirstTarget());
        if (controller == null || permanent == null || source == null) {
            return false;
        }
        PermanentCard newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
        newBluePrint.assignNewId();
        LikenessLooterCopyApplier applier = new LikenessLooterCopyApplier();
        applier.apply(game, (MageObject)newBluePrint, source, permanent.getId());
        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, permanent.getId());
        copyEffect.setApplier((CopyApplier)applier);
        Ability newAbility = source.copy();
        copyEffect.init(newAbility, game);
        game.addEffect((ContinuousEffect)copyEffect, newAbility);
        return true;
    }
}

