/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.l.LilahUndefeatedSlickshotEffect;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MulticoloredPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class LilahUndefeatedSlickshotTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterSpell filter = new FilterInstantOrSorcerySpell();

    LilahUndefeatedSlickshotTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private LilahUndefeatedSlickshotTriggeredAbility(LilahUndefeatedSlickshotTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LilahUndefeatedSlickshotTriggeredAbility copy() {
        return new LilahUndefeatedSlickshotTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !filter.match((StackObject)spell, this.getControllerId(), (Ability)this, game) || !Zone.HAND.equals((Object)spell.getFromZone())) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new LilahUndefeatedSlickshotEffect(new MageObjectReference((MageObject)spell, game)));
        return true;
    }

    public String getRule() {
        return "Whenever you cast a multicolored instant or sorcery spell from your hand, exile that spell instead of putting it into your graveyard as it resolves. If you do, it becomes plotted.";
    }

    static {
        filter.add((Predicate)MulticoloredPredicate.instance);
    }
}

