/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LilianaDeathMageUltimateEffect
extends OneShotEffect {
    LilianaDeathMageUltimateEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent loses 2 life for each creature card in their graveyard";
    }

    private LilianaDeathMageUltimateEffect(LilianaDeathMageUltimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaDeathMageUltimateEffect copy() {
        return new LilianaDeathMageUltimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent != null) {
            int amount = opponent.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            opponent.loseLife(amount * 2, game, source, false);
        }
        return true;
    }
}

