/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class LilianaUntouchedByDeathEffect
extends OneShotEffect {
    LilianaUntouchedByDeathEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards. If at least one Zombie card is milled this way, each opponent loses 2 life and you gain 2 life";
    }

    private LilianaUntouchedByDeathEffect(LilianaUntouchedByDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaUntouchedByDeathEffect copy() {
        return new LilianaUntouchedByDeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.millCards(3, source, game).getCards(game).stream().anyMatch(card -> card.hasSubtype(SubType.ZOMBIE, game))) {
            new LoseLifeOpponentsEffect(2).apply(game, source);
            player.gainLife(2, game, source);
        }
        return true;
    }
}

