/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LilianasDefeatEffect
extends OneShotEffect {
    LilianasDefeatEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target black creature or black planeswalker. If that permanent was a Liliana planeswalker, her controller loses 3 life";
    }

    private LilianasDefeatEffect(LilianasDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianasDefeatEffect copy() {
        return new LilianasDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player != null && permanent != null) {
            Player permanentController;
            permanent.destroy(source, game, true);
            game.processAction();
            if (permanent.isPlaneswalker(game) && permanent.hasSubtype(SubType.LILIANA, game) && (permanentController = game.getPlayer(permanent.getControllerId())) != null) {
                permanentController.loseLife(3, game, source, false);
            }
            return true;
        }
        return false;
    }
}

