/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.OrCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LimDulsHexEffect
extends OneShotEffect {
    LimDulsHexEffect() {
        super(Outcome.Damage);
        this.staticText = "for each player, {this} deals 1 damage to that player unless they pay {B} or {3}";
    }

    private LimDulsHexEffect(LimDulsHexEffect effect) {
        super((OneShotEffect)effect);
    }

    public LimDulsHexEffect copy() {
        return new LimDulsHexEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                OrCost costToPay = new OrCost("{B} or {3}", new Cost[]{new ManaCostsImpl("{B}"), new ManaCostsImpl("{3}")});
                costToPay.clearPaid();
                if (!player.chooseUse(Outcome.Benefit, "Pay {B} or {3}?", source, game) || !costToPay.pay(source, game, source, player.getId(), false, null)) {
                    game.informPlayers(player.getLogName() + " chooses not to pay " + costToPay.getText() + " to prevent 1 damage from " + sourcePermanent.getLogName());
                    player.damage(1, sourcePermanent.getId(), source, game);
                    continue;
                }
                game.informPlayers(player.getLogName() + " chooses to pay " + costToPay.getText() + " to prevent 1 damage from " + sourcePermanent.getLogName());
            }
            return true;
        }
        return false;
    }
}

