/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;

class LimitedResourcesEffect
extends OneShotEffect {
    LimitedResourcesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses five lands they control and sacrifices the rest";
    }

    private LimitedResourcesEffect(LimitedResourcesEffect effect) {
        super((OneShotEffect)effect);
    }

    public LimitedResourcesEffect copy() {
        return new LimitedResourcesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getState().getPlayersInRange(source.getControllerId(), game).forEach(playerId -> {
            Player player = game.getPlayer(playerId);
            if (player != null) {
                int lands = game.getBattlefield().countAll((FilterPermanent)new FilterControlledLandPermanent(), playerId, game);
                TargetLandPermanent target = new TargetLandPermanent(Integer.min(5, lands));
                target.withNotTarget(true);
                target.setRequired(true);
                player.chooseTarget(Outcome.Benefit, (Target)target, source, game);
                game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledLandPermanent(), playerId, game).stream().filter(land -> !target.getTargets().contains(land.getId())).forEachOrdered(land -> land.sacrifice(source, game));
            }
        });
        return true;
    }
}

