/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetControlledPermanent;

class LinessaZephyrMageEffect
extends OneShotEffect {
    LinessaZephyrMageEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Target player returns a creature they control to its owner's hand, then repeats this process for an artifact, an enchantment, and a land";
    }

    private LinessaZephyrMageEffect(LinessaZephyrMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public LinessaZephyrMageEffect copy() {
        return new LinessaZephyrMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (targetPlayer = game.getPlayer(source.getFirstTarget())) != null) {
            Permanent permanent;
            Permanent permanent2;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (target.choose(Outcome.ReturnToHand, targetPlayer.getId(), source.getSourceId(), source, game) && (permanent2 = game.getPermanent(target.getFirstTarget())) != null) {
                targetPlayer.moveCards((Card)permanent2, Zone.HAND, source, game);
            }
            FilterControlledPermanent filter = new FilterControlledPermanent("artifact you control");
            filter.add((Predicate)CardType.ARTIFACT.getPredicate());
            target = new TargetControlledPermanent(filter);
            target.withNotTarget(true);
            if (target.choose(Outcome.ReturnToHand, targetPlayer.getId(), source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                targetPlayer.moveCards((Card)permanent, Zone.HAND, source, game);
            }
            filter = new FilterControlledPermanent("enchantment you control");
            filter.add((Predicate)CardType.ENCHANTMENT.getPredicate());
            target = new TargetControlledPermanent(filter);
            target.withNotTarget(true);
            if (target.choose(Outcome.ReturnToHand, targetPlayer.getId(), source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                targetPlayer.moveCards((Card)permanent, Zone.HAND, source, game);
            }
            filter = new FilterControlledPermanent("land you control");
            filter.add((Predicate)CardType.LAND.getPredicate());
            target = new TargetControlledPermanent(filter);
            target.withNotTarget(true);
            if (target.choose(Outcome.ReturnToHand, targetPlayer.getId(), source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                targetPlayer.moveCards((Card)permanent, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

