/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LithomanticBarrageEffect
extends OneShotEffect {
    LithomanticBarrageEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 1 damage to target creature or planeswalker. It deals 5 damage instead if that target is white and/or blue";
    }

    private LithomanticBarrageEffect(LithomanticBarrageEffect effect) {
        super((OneShotEffect)effect);
    }

    public LithomanticBarrageEffect copy() {
        return new LithomanticBarrageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.getColor(game).isWhite() || permanent.getColor(game).isBlue()) {
            return permanent.damage(5, source, game) > 0;
        }
        return permanent.damage(1, source, game) > 0;
    }
}

