/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LittjaraMirrorlakeEffect
extends OneShotEffect {
    LittjaraMirrorlakeEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of target creature you control, except it enters the battlefield with an additional +1/+1 counter on it";
    }

    private LittjaraMirrorlakeEffect(LittjaraMirrorlakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LittjaraMirrorlakeEffect copy() {
        return new LittjaraMirrorlakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        effect.apply(game, source);
        for (Permanent permanent : effect.getAddedPermanents()) {
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

