/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class LivingConundrumDrawEffect
extends ReplacementEffectImpl {
    LivingConundrumDrawEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would draw a card while your library has no cards in it, skip that draw instead";
    }

    private LivingConundrumDrawEffect(LivingConundrumDrawEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public LivingConundrumDrawEffect copy() {
        return new LivingConundrumDrawEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Player player = game.getPlayer(event.getPlayerId());
        return player != null && !player.getLibrary().hasCards();
    }
}

