/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class LivingLoreCastEffect
extends OneShotEffect {
    LivingLoreCastEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast the exiled card without paying its mana cost";
    }

    private LivingLoreCastEffect(LivingLoreCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public LivingLoreCastEffect copy() {
        return new LivingLoreCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)permanent.getId(), (int)permanent.getZoneChangeCounter(game)));
        if (controller == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)exileZone), (FilterCard)StaticFilters.FILTER_CARD);
    }
}

