/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class LivioOathswornSentinelReturnEffect
extends OneShotEffect {
    LivioOathswornSentinelReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "return all exiled cards with aegis counters on them to the battlefield under their owners' control";
    }

    private LivioOathswornSentinelReturnEffect(LivioOathswornSentinelReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public LivioOathswornSentinelReturnEffect copy() {
        return new LivioOathswornSentinelReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = game.getExile().getCardsInRange(game, player.getId()).stream().filter(Objects::nonNull).filter(card -> card.getCounters(game).containsKey(CounterType.AEGIS)).collect(Collectors.toSet());
        return player.moveCards(cards, Zone.BATTLEFIELD, source, game, false, false, true, null);
    }
}

