/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class LoadingZoneEffect
extends ReplacementEffectImpl {
    LoadingZoneEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, false);
        this.staticText = "if one or more counters would be put on a creature, Spacecraft, or Planet you control, twice that many of each of those kinds of counters are put on it instead";
    }

    private LoadingZoneEffect(LoadingZoneEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowMultiply((int)event.getAmount(), (int)2), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() < 1) {
            return false;
        }
        Permanent permanent = Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(game.getPermanentEntering(event.getTargetId()));
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && (permanent.isCreature(game) || permanent.hasSubtype(SubType.SPACECRAFT, game) || permanent.hasSubtype(SubType.PLANET, game));
    }

    public LoadingZoneEffect copy() {
        return new LoadingZoneEffect(this);
    }
}

