/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class LobeliaSackvilleBagginsEffect
extends OneShotEffect {
    LobeliaSackvilleBagginsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from an opponent's graveyard that was put there from the battlefield this turn, then create X Treasure tokens, where X is the exiled card's power";
    }

    private LobeliaSackvilleBagginsEffect(LobeliaSackvilleBagginsEffect effect) {
        super((OneShotEffect)effect);
    }

    public LobeliaSackvilleBagginsEffect copy() {
        return new LobeliaSackvilleBagginsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        int power = card.getPower().getValue();
        if (power > 0) {
            new TreasureToken().putOntoBattlefield(power, game, source);
        }
        return true;
    }
}

