/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class LobotomyEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    private static final FilterCard filter = new FilterCard("card other than a basic land card");

    public LobotomyEffect() {
        super(false, "that player's", "all cards with the same name as the chosen card");
        this.staticText = "Target player reveals their hand, then you choose a card other than a basic land card from it. Search that player's graveyard, hand, and library for all cards with the same name as the chosen card and exile them. Then that player shuffles";
    }

    private LobotomyEffect(LobotomyEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (targetPlayer != null && sourceObject != null && controller != null) {
            targetPlayer.revealCards(sourceObject.getIdName(), targetPlayer.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, filter);
            target.withNotTarget(true);
            Card chosenCard = null;
            if (controller.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game)) {
                chosenCard = game.getCard(target.getFirstTarget());
            }
            return this.applySearchAndExile(game, source, CardUtil.getCardNameForSameNameSearch((Card)chosenCard), this.getTargetPointer().getFirst(game, source));
        }
        return false;
    }

    public LobotomyEffect copy() {
        return new LobotomyEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)Predicates.and((Predicate)CardType.LAND.getPredicate(), (Predicate)SuperType.BASIC.getPredicate())));
    }
}

