/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.ActivateAsSorceryActivatedAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToHandEffect;
import mage.abilities.effects.common.combat.CantBeBlockedSourceEffect;
import mage.abilities.keyword.FlashAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;

public final class LochmereSerpent
extends CardImpl {
    private static final FilterControlledPermanent filter1 = new FilterControlledPermanent(SubType.ISLAND, "an Island");
    private static final FilterControlledPermanent filter2 = new FilterControlledPermanent(SubType.SWAMP, "a Swamp");

    public LochmereSerpent(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{4}{U}{B}");
        this.subtype.add((Object)SubType.SERPENT);
        this.power = new MageInt(7);
        this.toughness = new MageInt(7);
        this.addAbility((Ability)FlashAbility.getInstance());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new CantBeBlockedSourceEffect(Duration.EndOfTurn), (Cost)new ManaCostsImpl("{U}"));
        ability.addCost((Cost)new SacrificeTargetCost((FilterPermanent)filter1));
        this.addAbility((Ability)ability);
        ability = new SimpleActivatedAbility((Effect)new GainLifeEffect(1), (Cost)new ManaCostsImpl("{B}"));
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(1).concatBy("and"));
        ability.addCost((Cost)new SacrificeTargetCost((FilterPermanent)filter2));
        this.addAbility((Ability)ability);
        ability = new ActivateAsSorceryActivatedAbility(Zone.GRAVEYARD, (Effect)new ExileTargetEffect().setText("Exile five target cards from an opponent's graveyard."), (Cost)new ManaCostsImpl("{U}{B}"));
        ability.addEffect((Effect)new ReturnSourceFromGraveyardToHandEffect());
        ability.addTarget((Target)new TargetCardInOpponentsGraveyard(5, 5, StaticFilters.FILTER_CARD, true));
        this.addAbility((Ability)ability);
    }

    private LochmereSerpent(LochmereSerpent card) {
        super((CardImpl)card);
    }

    public LochmereSerpent copy() {
        return new LochmereSerpent(this);
    }
}

