/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LockjawSnapperEffect
extends OneShotEffect {
    LockjawSnapperEffect() {
        super(Outcome.Neutral);
        this.staticText = "put a -1/-1 counter on each creature with a -1/-1 counter on it";
    }

    private LockjawSnapperEffect(LockjawSnapperEffect effect) {
        super((OneShotEffect)effect);
    }

    public LockjawSnapperEffect copy() {
        return new LockjawSnapperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)CounterType.M1M1.getPredicate());
        if (game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game).isEmpty()) {
            return true;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            if (creature == null) continue;
            creature.addCounters(CounterType.M1M1.createInstance(), source.getControllerId(), source, game);
            applied = true;
        }
        return applied;
    }
}

