/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class LongRestTarget
extends TargetCardInYourGraveyard {
    private static final FilterCard filter = new FilterCard("cards with different mana values from your graveyard");

    public LongRestTarget(int xValue) {
        super(xValue, filter);
    }

    private LongRestTarget(LongRestTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public LongRestTarget copy() {
        return new LongRestTarget(this);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Card card;
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        HashSet<Integer> usedManaValues = new HashSet<Integer>();
        for (UUID targetId : this.getTargets()) {
            card = game.getCard(targetId);
            if (card == null) continue;
            usedManaValues.add(card.getManaValue());
        }
        for (UUID possibleTargetId : super.possibleTargets(sourceControllerId, source, game)) {
            card = game.getCard(possibleTargetId);
            if (card == null || usedManaValues.contains(card.getManaValue())) continue;
            possibleTargets.add(possibleTargetId);
        }
        return possibleTargets;
    }
}

