/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LonghornFirebeastEffect
extends OneShotEffect {
    LonghornFirebeastEffect() {
        super(Outcome.Neutral);
        this.staticText = "any opponent may have it deal 5 damage to them. If a player does, sacrifice {this}";
    }

    private LonghornFirebeastEffect(LonghornFirebeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            for (UUID opponentUuid : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentUuid);
                if (opponent == null || !opponent.chooseUse(Outcome.LoseLife, "Make " + permanent.getLogName() + " deal 5 damage to you?", source, game)) continue;
                game.informPlayers(opponent.getLogName() + " has chosen to receive 5 damage from " + permanent.getLogName());
                opponent.damage(5, permanent.getId(), source, game);
                permanent.sacrifice(source, game);
                return true;
            }
            game.informPlayers("5 damage wasn't dealt so " + permanent.getLogName() + " won't be sacrificed.");
            return true;
        }
        return false;
    }

    public LonghornFirebeastEffect copy() {
        return new LonghornFirebeastEffect(this);
    }
}

