/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.l.LoreholdCommandEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.permanent.token.Spirit32Token;
import mage.game.permanent.token.Token;
import mage.target.TargetPlayer;
import mage.target.common.TargetAnyTarget;

public final class LoreholdCommand
extends CardImpl {
    public LoreholdCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{R}{W}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new CreateTokenEffect((Token)new Spirit32Token()));
        Mode mode = new Mode((Effect)new BoostControlledEffect(1, 0, Duration.EndOfTurn).setText("creatures you control get +1/+0"));
        mode.addEffect((Effect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES).setText("and gain indestructible"));
        mode.addEffect((Effect)new GainAbilityControlledEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES).setText("and haste until end of turn"));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new LoreholdCommandEffect());
        mode.addTarget(new TargetAnyTarget().withChooseHint("To deal damage"));
        mode.addTarget(new TargetPlayer().withChooseHint("To gain life"));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new SacrificeControllerEffect(StaticFilters.FILTER_PERMANENT, 1, ""));
        mode.addEffect((Effect)new DrawCardSourceControllerEffect(2).concatBy(", then"));
        this.getSpellAbility().addMode(mode);
    }

    private LoreholdCommand(LoreholdCommand card) {
        super((CardImpl)card);
    }

    public LoreholdCommand copy() {
        return new LoreholdCommand(this);
    }
}

