/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LoreholdExcavationEffect
extends OneShotEffect {
    private static final Effect effect = new DamagePlayersEffect(1, TargetController.OPPONENT);

    LoreholdExcavationEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill a card. If a land card was milled this way, you gain 1 life. Otherwise, {this} deals 1 damage to each opponent";
    }

    private LoreholdExcavationEffect(LoreholdExcavationEffect effect) {
        super((OneShotEffect)effect);
    }

    public LoreholdExcavationEffect copy() {
        return new LoreholdExcavationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.millCards(1, source, game).count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) > 0) {
            player.gainLife(1, game, source);
            return true;
        }
        effect.apply(game, source);
        return true;
    }
}

