/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class LostHoursEffect
extends OneShotEffect {
    LostHoursEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand. You choose a nonland card from it. That player puts that card into their library third from the top";
    }

    private LostHoursEffect(LostHoursEffect effect) {
        super((OneShotEffect)effect);
    }

    public LostHoursEffect copy() {
        return new LostHoursEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && controller != null) {
            targetPlayer.revealCards(source, targetPlayer.getHand(), game);
            if (targetPlayer.getHand().size() > 0) {
                Card card;
                TargetCard target = new TargetCard(Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
                if (controller.choose(Outcome.Discard, targetPlayer.getHand(), target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                    targetPlayer.putCardOnTopXOfLibrary(card, game, source, 3, true);
                }
            }
            return true;
        }
        return false;
    }
}

