/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LothlorienBladeEffect
extends OneShotEffect {
    LothlorienBladeEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals damage equal to its power to target creature defending player controls";
    }

    private LothlorienBladeEffect(LothlorienBladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LothlorienBladeEffect copy() {
        return new LothlorienBladeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent equipment = source.getSourcePermanentOrLKI(game);
        if (targetCreature == null || equipment == null) {
            return false;
        }
        Permanent attacker = game.getPermanentOrLKIBattlefield(equipment.getAttachedTo());
        if (attacker == null) {
            return false;
        }
        targetCreature.damage(attacker.getPower().getValue(), attacker.getId(), source, game);
        return true;
    }
}

