/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LovestruckBeastEffect
extends RestrictionEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    LovestruckBeastEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless you control a 1/1 creature";
    }

    private LovestruckBeastEffect(LovestruckBeastEffect effect) {
        super((RestrictionEffect)effect);
    }

    public LovestruckBeastEffect copy() {
        return new LovestruckBeastEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && game.getBattlefield().countAll(filter, source.getControllerId(), game) <= 0;
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, 1));
        filter.add((Predicate)new ToughnessPredicate(ComparisonType.EQUAL_TO, 1));
    }
}

