/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.ExileSourceEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.ReturnFromExileEffect;
import mage.cards.l.LuciusTheEternalDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class LuciusTheEternalEffect
extends OneShotEffect {
    LuciusTheEternalEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile it and choose target creature an opponent controls. When that creature leaves the battlefield, return this card from exile to the battlefield under its owner's control.";
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean exiled = new ExileSourceEffect(true).apply(game, source);
        game.processAction();
        new CreateDelayedTriggeredAbilityEffect((DelayedTriggeredAbility)new LuciusTheEternalDelayedTriggeredAbility((Effect)new ReturnFromExileEffect(Zone.BATTLEFIELD))).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        String luciusDescription = exiled ? CardUtil.getSourceIdName((Game)game, (Ability)source) : CardUtil.getSourceName((Game)game, (Ability)source);
        InfoEffect.addInfoToPermanent((Game)game, (Ability)source, (Permanent)permanent, (String)("(When this creature leaves the battlefield, return " + luciusDescription + " from exile to the battlefield under its owner's control)"));
        return true;
    }

    private LuciusTheEternalEffect(LuciusTheEternalEffect effect) {
        super((OneShotEffect)effect);
    }

    public LuciusTheEternalEffect copy() {
        return new LuciusTheEternalEffect(this);
    }
}

