/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.WinGameSourceControllerEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class LuckBobbleheadEffect
extends OneShotEffect {
    private static final DynamicValue xValue = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent(SubType.BOBBLEHEAD, "Bobbleheads you control"), null);
    static final Hint hint = new ValueHint("Bobbleheads you control", xValue);

    LuckBobbleheadEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll X six-sided dice, where X is the number of Bobbleheads you control. Create a tapped Treasure token for each even result. If you rolled 6 exactly seven times, you win the game";
    }

    private LuckBobbleheadEffect(LuckBobbleheadEffect effect) {
        super((OneShotEffect)effect);
    }

    public LuckBobbleheadEffect copy() {
        return new LuckBobbleheadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = xValue.calculate(game, source, (Effect)this);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || amount <= 0) {
            return false;
        }
        List rolls = controller.rollDice(Outcome.Benefit, source, game, 6, amount, 0);
        int evenRolls = rolls.stream().filter(i -> i != null && i % 2 == 0).mapToInt(i -> 1).sum();
        int sixRolls = rolls.stream().filter(i -> i == 6).mapToInt(i -> 1).sum();
        if (evenRolls > 0) {
            new CreateTokenEffect((Token)new TreasureToken(), evenRolls, true).apply(game, source);
        }
        if (sixRolls == 7) {
            new WinGameSourceControllerEffect().apply(game, source);
        }
        return true;
    }
}

