/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LukeSkywalkerCost
extends CostImpl {
    public LukeSkywalkerCost() {
        this.text = "Remove all +1/+1 counters from {this}";
    }

    private LukeSkywalkerCost(LukeSkywalkerCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(ability.getSourceId());
        if (permanent != null) {
            return permanent.getCounters(game).getCount(CounterType.P1P1) > 0;
        }
        return false;
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Permanent permanent = game.getPermanent(ability.getSourceId());
        if (permanent != null) {
            int countersCount = permanent.getCounters(game).getCount(CounterType.P1P1);
            permanent.removeCounters(CounterType.P1P1.createInstance(countersCount), source, game);
            this.paid = true;
            return true;
        }
        return false;
    }

    public LukeSkywalkerCost copy() {
        return new LukeSkywalkerCost(this);
    }
}

