/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class LuminatePrimordialEffect
extends OneShotEffect {
    LuminatePrimordialEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each opponent, exile up to one target creature that player controls and that player gains life equal to its power";
    }

    private LuminatePrimordialEffect(LuminatePrimordialEffect effect) {
        super((OneShotEffect)effect);
    }

    public LuminatePrimordialEffect copy() {
        return new LuminatePrimordialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set permanents = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<UUID, Integer> map = permanents.stream().collect(Collectors.toMap(Controllable::getControllerId, permanent -> permanent.getPower().getValue()));
        controller.moveCards(permanents, Zone.EXILED, source, game);
        for (Map.Entry<UUID, Integer> entry : map.entrySet()) {
            Player player = game.getPlayer(entry.getKey());
            if (player == null || entry.getValue() <= 0) continue;
            player.gainLife(entry.getValue().intValue(), game, source);
        }
        return true;
    }
}

