/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class LuminescePreventionEffect
extends PreventionEffectImpl {
    LuminescePreventionEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "Prevent all damage that black sources and red sources would deal this turn";
    }

    private LuminescePreventionEffect(LuminescePreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject sourceObject;
        return !(!super.applies(event, source, game) || event.getType() != GameEvent.EventType.DAMAGE_PLAYER && event.getType() != GameEvent.EventType.DAMAGE_PERMANENT || (sourceObject = game.getObject(event.getSourceId())) == null || !sourceObject.getColor(game).shares(ObjectColor.BLACK) && !sourceObject.getColor(game).shares(ObjectColor.RED));
    }

    public LuminescePreventionEffect copy() {
        return new LuminescePreventionEffect(this);
    }
}

