/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class LuminescentRainEffect
extends OneShotEffect {
    LuminescentRainEffect() {
        super(Outcome.GainLife);
        this.staticText = "Choose a creature type. You gain 2 life for each permanent you control of that type.";
    }

    private LuminescentRainEffect(LuminescentRainEffect effect) {
        super((OneShotEffect)effect);
    }

    public LuminescentRainEffect copy() {
        return new LuminescentRainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (player != null && player.choose(Outcome.BoostCreature, (Choice)typeChoice, game)) {
            FilterControlledPermanent filter = new FilterControlledPermanent();
            filter.add((Predicate)SubType.byDescription((String)typeChoice.getChoiceKey()).getPredicate());
            return new GainLifeEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)filter, Integer.valueOf(2))).apply(game, source);
        }
        return false;
    }
}

