/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTypeTargetEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BecomesChosenCreatureTypeControlledEffect
extends OneShotEffect {
    BecomesChosenCreatureTypeControlledEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Choose a creature type. Each creature you control becomes that type until end of turn";
    }

    private BecomesChosenCreatureTypeControlledEffect(BecomesChosenCreatureTypeControlledEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getSourceId());
        String chosenType = "";
        if (player != null && card != null) {
            ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
            if (!player.choose(Outcome.BoostCreature, (Choice)typeChoice, game)) {
                return false;
            }
            game.informPlayers(card.getName() + ": " + player.getLogName() + " has chosen " + typeChoice.getChoiceKey());
            chosenType = typeChoice.getChoiceKey();
            if (chosenType != null && !chosenType.isEmpty()) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), player.getId(), game)) {
                    BecomesCreatureTypeTargetEffect effect = new BecomesCreatureTypeTargetEffect(Duration.EndOfTurn, SubType.byDescription((String)chosenType));
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
                return true;
            }
        }
        return false;
    }

    public BecomesChosenCreatureTypeControlledEffect copy() {
        return new BecomesChosenCreatureTypeControlledEffect(this);
    }
}

