/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CantAttackUnlessControllerControlsMoreLandsEffect
extends RestrictionEffect {
    CantAttackUnlessControllerControlsMoreLandsEffect() {
        super(Duration.WhileOnBattlefield);
    }

    private CantAttackUnlessControllerControlsMoreLandsEffect(CantAttackUnlessControllerControlsMoreLandsEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        UUID defendingPlayerId;
        if (defenderId == null) {
            return true;
        }
        Player defender = game.getPlayer(defenderId);
        if (defender == null) {
            Permanent permanent = game.getPermanent(defenderId);
            if (permanent == null) return false;
            defendingPlayerId = permanent.getControllerId();
        } else {
            defendingPlayerId = defenderId;
        }
        if (defendingPlayerId == null) return true;
        if (game.getBattlefield().countAll((FilterPermanent)new FilterControlledLandPermanent(), source.getControllerId(), game) <= game.getBattlefield().countAll((FilterPermanent)new FilterControlledLandPermanent(), defendingPlayerId, game)) return false;
        return true;
    }

    public CantAttackUnlessControllerControlsMoreLandsEffect copy() {
        return new CantAttackUnlessControllerControlsMoreLandsEffect(this);
    }
}

